 

IF NOT OBJECT_ID('UFD_EST_PROD_CPL_MEDIAP_ALCADA') IS NULL
	BEGIN 
		DROP FUNCTION UFD_EST_PROD_CPL_MEDIAP_ALCADA
	END

GO

--SELECT * FROM UFD_EST_PROD_CPL_MEDIAP_ALCADA(1,1,37888)
CREATE FUNCTION UFD_EST_PROD_CPL_MEDIAP_ALCADA(@CD_EMP	INT,
												 @CD_FILIAL	INT,
												 @CD_PROD	INT)
RETURNS @RS_RESULT TABLE (	CD_EMP		INT,							
							CD_FILIAL	INT,
							QT_BASE_ALCADA		MONEY)
AS							
	BEGIN 
		DECLARE @CD_ARV_MERC_CATEG INT
		DECLARE @DT_INI DATETIME
		DECLARE @DT_FIM DATETIME
		DECLARE @DT_ANO_MES_INI INT
		DECLARE @DT_ANO_MES_FIM INT		
					 
			
		SET @DT_INI = CONVERT(VARCHAR(10),DATEADD(MONTH,-3,GETDATE()), 101)
		SET @DT_FIM = CONVERT(VARCHAR(10),GETDATE(), 101)				

		SET @DT_ANO_MES_INI =  (SELECT CONVERT(VARCHAR(6), @DT_INI, 112))
		SET @DT_ANO_MES_FIM =  (SELECT CONVERT(VARCHAR(6), @DT_FIM, 112))

		SET @CD_ARV_MERC_CATEG = ISNULL((SELECT CD_ARV_MERC_CATEG
										FROM EST_PROD_EST_ARV_MERCADOLOGICA
										WHERE 
											CD_EMP = @CD_EMP
											AND CD_PROD = @CD_PROD),0)

				
		INSERT INTO @RS_RESULT
			SELECT  I.CD_EMP, 					
					@CD_FILIAL,
					SUM(I.QT_IT) / COUNT(DISTINCT MONTH(DT_VD)) / COUNT(DISTINCT I.CD_PROD)								
			FROM PDV_VD_IT I	
				INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
					I.CD_EMP = A.CD_EMP
					AND I.CD_PROD = A.CD_PROD 
			WHERE 				
				I.CD_EMP 		= @CD_EMP
				AND I.CD_FILIAL = @CD_FILIAL 			
				AND I.ST_IT 	= 1
				AND A.CD_ARV_MERC_CATEG = @CD_ARV_MERC_CATEG
				--AND ANO_MES BETWEEN @DT_ANO_MES_INI AND @DT_ANO_MES_FIM					
				AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM 				
			GROUP BY 
				I.CD_EMP 			
				
		RETURN
							
	END


  